// SingleEntry.cpp : Implementierungsdatei
//

#include "stdafx.h"
#include "ListList_CPP V7.h"
#include "SingleEntry.h"

// CSingleEntry

CSingleEntry::CSingleEntry()
{
	ParentList = NULL;
}

CSingleEntry::CSingleEntry(const CString& EName)
	: FEntryName(EName), ParentList(NULL)
{
}

CSingleEntry::CSingleEntry(const CString& EName, CSingleEntry* Parent) 
  : FEntryName(EName), ParentList(Parent)
{
}

CSingleEntry::~CSingleEntry()
{
}

CString CSingleEntry::FullName()
{
  if (ParentList != NULL) 
    return ParentList->FullName()+"\\"+FEntryName;
	else return FEntryName;
}

CString CSingleEntry::GetDisplayName()
{
	return FEntryName; 
}


CSingleEntry* CSingleEntry::AddEntry(const CString& EName)
{
	AfxMessageBox("CSingleEntry: AddEntry/AddNode not implemented.");
	AfxThrowUserException();
	return NULL;
}

CSingleEntry* CSingleEntry::AddNode(const CString& NName)
{
	return AddEntry(NName);
}

CSingleEntry* CSingleEntry::FindEntry(const CString& PartialName)
{
	if (FEntryName == PartialName) 
		return this; 
	else 
		return NULL;
}



// CListEntry

CListEntry::CListEntry()
{
}

CListEntry::CListEntry(const CString& EName) : CSingleEntry(EName)
{
}

CListEntry::CListEntry(const CString& EName, CSingleEntry* Parent)
: CSingleEntry(EName, Parent)
{
}

// In C++ ist ein Destruktor ntig, der die Listen durchluft
// Die Liste selbst wird zusammen mit dem Objekt abgerumt
CListEntry::~CListEntry()
{ 
	for (int x = 0; x < EntryList.GetCount(); x++)
	  delete EntryList[x];
}

CSingleEntry* CListEntry::FindEntry(const CString& PartialName)
{ 
	CSingleEntry* Result = CSingleEntry::FindEntry(PartialName);

	if (Result == NULL)
		for (int x = 0; x < EntryList.GetCount(); x++)
		{ CSingleEntry* E = (CSingleEntry*)EntryList.GetAt(x);
	
		Result = E->FindEntry(PartialName);
		if (Result != NULL)
			break;
		}
	return Result;

}


CSingleEntry* CListEntry::AddEntry(const CString& EName)
{ CSingleEntry* Result = new CSingleEntry(EName, this);

  EntryList.Add(Result);
  return Result;
}

CSingleEntry* CListEntry::AddNode(const CString& NName)
{ CListEntry* Result = new CListEntry(NName, this);

  EntryList.Add(Result);
  return Result;
}

CSingleEntry* CListEntry::GetEntry(int Index)
{ 
	if (Index < 0 || Index >= EntryList.GetCount()) return NULL;
	  else return (CSingleEntry*)EntryList[Index];
}

CString CListEntry::GetDisplayName()
{
	return CSingleEntry::GetDisplayName() + " (LIST)";
}
